/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_8037;
import net.minecraft.class_8038;
import net.minecraft.class_8042;
import net.minecraft.class_8609;
import net.minecraft.class_8710;
import net.minecraft.class_9095;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;

public class PacketRedirection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketRedirection.class);
    public static final class_2960 payloadId = McHelper.newResourceLocation("i:r");
    private static final ThreadLocal<class_5321<class_1937>> serverPacketRedirection = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<ForceBundleCallback> forceBundle = ThreadLocal.withInitial(() -> null);
    private static final class_9127<class_2602> PLACEHOLDER_PROTOCOL_INFO = class_9095.field_48173.method_61107(argBuf -> (class_9129)argBuf);

    public static void init() {
        PayloadTypeRegistry.playS2C().register(Payload.TYPE, Payload.CODEC);
    }

    public static void withForceRedirect(class_3218 world, Runnable func) {
        PacketRedirection.withForceRedirectAndGet(world, () -> {
            func.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withForceRedirectAndGet(class_3218 world, Supplier<T> func) {
        if (((IEWorld)world).portal_getThread() != Thread.currentThread()) {
            LOGGER.error("It's possible that a mod is trying to handle packet in networking thread instead of server thread. This is not thread safe and can cause rare bugs! (ImmPtl is just doing checking, it's not an issue of iPortal)", new Throwable());
        }
        class_5321 redirectDim = world.method_27983();
        class_5321<class_1937> oldRedirection = serverPacketRedirection.get();
        if (oldRedirection != redirectDim) {
            serverPacketRedirection.set((class_5321<class_1937>)redirectDim);
        }
        try {
            T t = func.get();
            return t;
        }
        finally {
            if (oldRedirection != redirectDim) {
                serverPacketRedirection.set(oldRedirection);
            }
        }
    }

    @Nullable
    public static class_5321<class_1937> getForceRedirectDimension() {
        return serverPacketRedirection.get();
    }

    public static void sendRedirectedPacket(class_3244 serverPlayNetworkHandler, class_2596<class_2602> packet, class_5321<class_1937> dimension) {
        if (PacketRedirection.getForceRedirectDimension() == dimension) {
            serverPlayNetworkHandler.method_14364(packet);
        } else {
            serverPlayNetworkHandler.method_14364(PacketRedirection.createRedirectedMessage(serverPlayNetworkHandler.field_14140.field_13995, dimension, packet));
        }
    }

    public static void validateForceRedirecting() {
        Validate.isTrue((PacketRedirection.getForceRedirectDimension() != null ? 1 : 0) != 0);
    }

    public static class_2596<class_2602> createRedirectedMessage(MinecraftServer server, class_5321<class_1937> dimension, class_2596<class_2602> packet) {
        if (PacketRedirection.isRedirectPacket(packet)) {
            return packet;
        }
        Validate.isTrue((!(packet instanceof class_8037) ? 1 : 0) != 0);
        if (packet instanceof class_8042) {
            class_8042 bundlePacket = (class_8042)packet;
            ArrayList<class_2596<class_2602>> newSubPackets = new ArrayList<class_2596<class_2602>>();
            for (class_2596 subPacket : bundlePacket.method_48324()) {
                newSubPackets.add(PacketRedirection.createRedirectedMessage(server, dimension, (class_2596<class_2602>)subPacket));
            }
            return new class_8042(newSubPackets);
        }
        int intDimId = PortalAPI.serverDimKeyToInt(server, dimension);
        Payload payload = new Payload(intDimId, packet);
        return new class_2658((class_8710)payload);
    }

    public static void sendRedirectedMessage(class_3222 player, class_5321<class_1937> dimension, class_2596<class_2602> packet) {
        player.field_13987.method_14364(PacketRedirection.createRedirectedMessage(player.field_13995, dimension, packet));
    }

    public static boolean isRedirectPacket(class_2596<?> packet) {
        class_2658 customPayloadPacket;
        return packet instanceof class_2658 && (customPayloadPacket = (class_2658)packet).comp_1646() instanceof Payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withForceBundle(Supplier<R> func) {
        ForceBundleCallback forceBundleCallback = PacketRedirection.getForceBundleCallback();
        if (forceBundleCallback != null) {
            return func.get();
        }
        HashMap map = new HashMap();
        forceBundle.set((listener, packet) -> {
            List packetsToBundle = map.computeIfAbsent(listener, k -> new ArrayList());
            if (packet instanceof class_8038) {
                class_8038 bundlePacket = (class_8038)packet;
                Iterable subPackets = bundlePacket.method_48324();
                for (class_2596 subPacket : subPackets) {
                    packetsToBundle.add(subPacket);
                }
            } else {
                packetsToBundle.add(packet);
            }
        });
        try {
            R r = func.get();
            return r;
        }
        finally {
            forceBundle.set(null);
            for (Map.Entry e : map.entrySet()) {
                class_8609 listener2 = (class_8609)e.getKey();
                List packets = (List)e.getValue();
                listener2.method_14364((class_2596)new class_8042((Iterable)packets));
            }
        }
    }

    @Nullable
    public static ForceBundleCallback getForceBundleCallback() {
        return forceBundle.get();
    }

    public record Payload(int dimensionIntId, class_2596<? extends class_2602> packet) implements class_8710
    {
        public static final class_8710.class_9154<Payload> TYPE = new class_8710.class_9154(payloadId);
        public static final class_9139<class_9129, Payload> CODEC = class_9139.method_56437((b, p) -> p.write((class_9129)b), Payload::read);

        public void write(class_9129 buf) {
            Validate.notNull(this.packet, (String)"packet is null", (Object[])new Object[0]);
            buf.method_10804(this.dimensionIntId);
            PLACEHOLDER_PROTOCOL_INFO.comp_2236().encode((Object)buf, this.packet);
        }

        public static Payload read(class_2540 buf) {
            int dimensionIntId = buf.method_10816();
            class_2596 packet = (class_2596)PLACEHOLDER_PROTOCOL_INFO.comp_2236().decode((Object)buf);
            return new Payload(dimensionIntId, (class_2596<? extends class_2602>)packet);
        }

        @Environment(value=EnvType.CLIENT)
        public void handle(class_2602 listener) {
            PacketRedirectionClient.handleRedirectedPacket(this.dimensionIntId, this.packet, listener);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public static interface ForceBundleCallback {
        public void accept(class_8609 var1, class_2596<class_2602> var2);
    }
}

